#!/bin/sh
#
# Shell script to install Java-based GUI RAID Manager.

SRCDIR=`pwd`
OSDIR=${SRCDIR}
COMDIR=${SRCDIR}

if [ ! -r /usr/.path.ori ]; then
   echo "`echo $PATH`" > /usr/.path.ori
fi

# Set path for JRE
export PATH; PATH=/usr/local/j2re1.4.2/bin:$PATH

more << "EOF"

	*************************************************************
             Java-based GUI RAID Manager Installation Procedure
        *************************************************************

SECTION I : JRE v1.4.2 Installation

*NOTE: 1.Before you can run Java-based program successfully, you should have
         installed JRE(Java Runtime Enviroment).
       2.JRE v1.4.2 will be installed on /usr/local/j2re1.4.2 .
EOF
 
echo "Would you like to install JRE v1.4.2 now?"
agreed=
while [ x$agreed = x ]; do
    echo "Please type yes or no."
    read reply 
    case $reply in
       y* | Y*)
          mkdir /usr/local > /dev/null 2>&1;
          cd /usr/local;
          tar -xvf ${OSDIR}/j2re1.4.2.tar;
	  echo "Install JRE v1.4.2 finished!"
	  agreed=1;;
       n* | N*)
	  echo "Install JRE v1.4.2 Canceled!"
          agreed=1;;
    esac
done

# Check to see if glibc-2.1.2 or higher exists.
# Method 1
/usr/local/j2re1.4.2/bin/java -version > /dev/null 2>&1
if [ $? != 0 ]; then
   echo "JRE doesn't exist or installed is old version."
   echo "JRE v1.2.2 needs at least a glibc-2.1.2 based system with a recent 2.2.xx kernel."
   echo "Install failed!"
   return
else
   PATH=/usr/local/j2re1.4.2/bin:`cat /usr/.path.ori`; export PATH
fi 

# Method 2
# (${SRCDIR}/j2re1.4.2/bin/java > /dev/null) 2>log.dat
# if !(test -s log.dat); then
#   echo "JRE v1.2.2 needs at least a glibc-2.1.2 based system with a recent
# 2.2.xx kernel."            echo "Install failed !"
#   rm -f log.dat
#   exit 1
# fi
# rm -f log.dat

# Method 2 for option selection code structure
# while true; do
#   echo 1>&2 "Please type yes or no."
#   read RESPONSE
#   if [ "$RESPONSE" = yes ];then
#     cd /usr/local
#     ${SRCDIR}/jre-1.2.2-RC4-linux-i386-glibc-2.1.2.sh
#     break
#  fi
#  if [ "$RESPONSE" = no ]; then 
#     break
#  fi
# done

more << "EOF"

-----------------------------------------------------------------------------
SECTION II : Java Plug-in v1.2.2 Installation

*NOTE: If you would like to run Java-based GUI RAID Manager through web
       browser(e.g. Netscape Navigator), you should have install Java Plug-
       in. Check to see if directory ${HOME}/.netscape/ exists.

EOF
 
echo "Would you like to install Java Plug-in v1.2.2 now?"
agreed=
while [ x$agreed = x ]; do
    echo "Please type yes or no."
    read reply 
    case $reply in
       y* | Y*)
          ${OSDIR}/j2pi.sh;
	  agreed=1;;
       n* | N*)
	  echo "Install Java Plug-in v1.2.2 Canceled!"	
          agreed=1;;
    esac
done

# Install .java.policy & .keystore
rm -f ${HOME}/.keystore
rm -f ${HOME}/.java.policy
(cp -f ${COMDIR}/keystore.jav ${HOME}/.keystore) > /dev/null 2>&1
(cp -f ${COMDIR}/policy.jav ${HOME}/.java.policy) > /dev/null 2>&1

more << "EOF"

----------------------------------------------------------------------------
SECTION III : Java-based GUI RAID Manager Installation

*NOTE: To install and configure Java-based GUI RAID Manager successfully,
       We highly recommend you refer to INSTALLATION GUIDE first.

EOF

echo "Would you like to install Java-based GUI RAID Manager now?"
agreed=
while [ x$agreed = x ]; do
    echo "Please type yes or no."
    read reply 
    case $reply in
       y* | Y*)
          cd $COMDIR; 
          java -Djava.compiler="" -jar installshield.jar > /dev/null 2>&1;
          agreed=1;;
       n* | N*)
          echo "Install Java-based GUI RAID Manager Canceled!";
          agreed=1;;
    esac
done

